<?php

namespace Filament\Tables\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class TrashedFilter extends TernaryFilter
{
    public static function getDefaultName(): ?string
    {
        return 'trashed';
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->label(__('Data yang ditampilkan'));

        $this->placeholder(__('Tanpa data yang dihapus'));

        $this->trueLabel(__('Beserta data yang dihapus'));

        $this->falseLabel(__('Hanya data yang dihapus'));

        $this->queries(
            true: fn ($query) => $query->withTrashed(),
            false: fn ($query) => $query->onlyTrashed(),
            blank: fn ($query) => $query->withoutTrashed(),
        );

        $this->baseQuery(fn (Builder $query) => $query->withoutGlobalScopes([
            SoftDeletingScope::class,
        ]));

        $this->indicateUsing(function (array $state): array {
            if ($state['value'] ?? null) {
                return [Indicator::make($this->getTrueLabel())];
            }

            if (blank($state['value'] ?? null)) {
                return [];
            }

            return [Indicator::make($this->getFalseLabel())];
        });
    }
}
